using System;
using System.Threading;

namespace OrderingClient
{
	/// <summary>
	/// Opis klasy OrderProcessor.
	/// </summary>
	public class OrderProcessor
	{
		private static int curNoOrders = 0;
		private Random rand;

		public OrderProcessor()
		{
			rand = new Random();
		}

		public int ProcessOrder()
		{
			Thread th = new Thread(new ThreadStart(doOrder));
			th.Start();

			curNoOrders++;
			return 0;
		}

		public int CurNoOrders
		{
			get 
			{
				return curNoOrders;
			}
			set 
			{
				curNoOrders = value;
			}
		}

		private void doOrder()
		{
			for (int delay = rand.Next(10000000);
				delay >= 0;
				delay--)
				;

			curNoOrders--;
		}
	}
}
